-- GPS virtual course for F3F script for EdgeTX and OpenTX
-- https://rc-soar.com/edgetx/lua/gpsf3f/
-- Copyright (c) Michael Shellim 2025 all rights reserved.

-- Countdown timer module
local timer = {}

local tCountdown    -- start time (seconds) for countdown timer
local t0        -- base time for timer (10 mS units)
local t1     -- next second tick (10mS units)

function timer.start(t)
    tCountdown = t
    t0 = getTime() 
    t1 = t0
end

-- Function to poll the timer.
--  If tick event, returns ticks remaining (secs) else nil
function timer.poll()
    local now = getTime()
    if now > t1 then
        local wholeSecondsElapsed = math.floor ((now - t0) / 100)
        t1 = t0 + (wholeSecondsElapsed+1) * 100
        print ("Timer tick: " .. (tCountdown - wholeSecondsElapsed) )
        return tCountdown - wholeSecondsElapsed
    end
end

return timer
