-- GPS virtual course for F3F script for EdgeTX and OpenTX
-- https://rc-soar.com/edgetx/lua/gpsf3f/
-- Copyright (c) Michael Shellim 2025 all rights reserved.

-- Switch class
-- This class is used to detect state transitions of logical switches
-- Each instance is associated with a logical switch.
local switch = {}
switch.PRESSED = true
switch.RELEASED = false

local getLsVal                              -- o/s independent, takes base-1 logical switch number
if getLogicalSwitchValue then
    getLsVal = function (lsBase1) return getLogicalSwitchValue (lsBase1-1) end  -- EdgeTX 
else
    getLsVal = function (lsBase1) return getValue("ls" .. lsBase1) > 0 end      -- OpenTX (inefficient)
end

-- constructor for switch class
-- Usage: sw = switch:new ({getLogSwitch = someFunction})
--  getLogSwitch: function to get logical switch id (base 1). We pass a function rather than 
--  the ls number directly in order to respond dynamically to changes in ls number.
function switch.new(self, o)
    setmetatable(o, self)
    self.__index = self
    o.lastState = true
    return o
end

-- Returns switch state if it has changed since last call, otherwise nil
function switch.event(self)
    local state = getLsVal(self.getlogSwitch())
    if state ~= self.lastState then
        self.lastState = state
        return state
    else
        return nil
    end
end


return switch
