-- GPS virtual course for F3F script for EdgeTX and OpenTX
-- https://rc-soar.com/edgetx/lua/gpsf3f/
-- Copyright (c) Michael Shellim 2025 all rights reserved.

local intervalTimer = {}
local t0    -- start time of last interval
local ema   -- Exponential Moving Average
local previousEma   -- previous EMA value
local ALPHA = 0.1   -- smoothing factor for EMA

function intervalTimer.init ()
    t0 = nil
    previousEma = nil
    ema = nil
end

function intervalTimer.update ()
    -- local now = os.clock()
    local now = getTime()  -- getTime() returns time in 10mS units
    if t0 ~= nil then
        local currentValue = now - t0
        if previousEma == nil then
            ema = currentValue  -- First value becomes the initial EMA
        else
            ema = ALPHA * currentValue + (1 - ALPHA) * previousEma
        end
        previousEma = ema
    end
    t0 = now
end

-- @@returns frequency in Hz, or nil if not available
function intervalTimer.getFrequency ()
    if ema and ema > 0 then
        return math.floor ((100/ema)  + 0.5) --convert to Hz and round
    else
        return nil
    end
end


return intervalTimer