-- GPS virtual course for F3F script for EdgeTX and OpenTX
-- https://rc-soar.com/edgetx/lua/gpsf3f/
-- Copyright (c) Michael Shellim 2025 all rights reserved.

-- Timer module. One timer for both countdown (for climbout) and countup (for on-course)
-- Usage:
-- Climb (30 second timer):
--      timer.start (30) start in countdown mode
-- WHen starting the course timer:
--      timer.start() restart in countup mode
-- On the course:
--      timer.poll()

local timer = {}

local tStart    -- start time (seconds) for countdown timer
local hNext     -- next second tick (10mS units)
local h0        -- base time for timer (10 mS units)

function timer.start(t)
    tStart = t
    h0 = getTime() -- 10 mS units
    hNext = h0
end

-- Function to poll the timer.
--  If tick event, returns ticks remaining (secs) else nil
function timer.poll()
    local h = getTime()
    if h > hNext then
        local t = math.floor ((h - h0) / 100)
        hNext = h0 + (t+1) * 100
        return tStart -t
    end
end

return timer
