-- GPS virtual course for F3F script for EdgeTX and OpenTX
-- https://rc-soar.com/edgetx/lua/gpsf3f/
-- Copyright (c) Michael Shellim 2025 all rights reserved.

-- module with drawing functions. 
local graph={}

local dx, dy -- origin shift
local xScale, yScale -- scaling factors
local hTallBlob
local hShortBlob
local cross
local slat
local drawLine = lcd.drawLine -- performance optimisation

-- forward declarations for helper functions
local transform

-- initialisations
function graph.init (x0, y0, wid, height)
    dx = x0 + wid/2         -- centre-align horizontally
    dy = y0 + height/2      -- centre-align vertically 
    if height > wid / 8 then height = wid / 8  end -- limit the aspect ratio to avoid distortion
    xScale = wid/150        -- full width => 150m
    yScale = height/30      -- full height => 30m
    hTallBlob = math.floor(height * 0.4)
    hShortBlob = math.floor(height * 0.2)
    cross = math.floor(height * 0.2)
    slat = math.floor(height * 0.15)
end

function graph.drawBlob (x, y, isTall)
    x, y = transform (x, y)
    local blob = isTall and hTallBlob or hShortBlob
    drawLine (x, y - blob, x, y + blob, SOLID, 0)
end

function graph.drawDiagCross (x, y)
    x, y = transform (x, y)
    drawLine (x - cross, y - cross, x + cross, y + cross, SOLID, 0)
    drawLine (x + cross, y - cross, x - cross, y + cross, SOLID, 0)
end

function graph.drawCross (x, y)
    x, y = transform (x, y)
    drawLine (x - cross, y, x + cross, y, SOLID, 0)
    drawLine (x, y - cross, x, y + cross, SOLID, 0)
end

function graph.drawSlats (x, y)
    x, y = transform (x, y)
    y = y - slat
    x = x - 2
    for _ = 1, 3 do
        drawLine (x - slat, y, x + slat, y, SOLID, 0)
        y = y + slat
        x = x + 2
    end
end

-- local helper functions (must have forward declarations)
function transform (x, y)
    return  x*xScale + dx, -y*yScale + dy
end

return graph
