-- GPS virtual course for F3F script for EdgeTX and OpenTX
-- https://rc-soar.com/edgetx/lua/gpsf3f/
-- Copyright (c) Michael Shellim 2025 all rights reserved.

-- Counter class to count the number of times a function is called in a given period.

local counter= {}
local duration = 1000 -- 100th's of second (=10 secs)

function counter.new(self, o)
    o = o or {}
    setmetatable(o, self)
    self.__index = self
    o.count = 0
    o.tMax = getTime() + duration
    o.lastCount = nil
    return o
end

function counter.increment(self)
    self.count = self.count + 1
    local t = getTime()
    if t > self.tMax then
        self.lastCount = self.count
        self.count = 0
        self.tMax = t + duration -- reset timer to 10 secs
    end
end

function counter.getCount(self)
    return self.lastCount and self.lastCount / 10 or nil -- return count per second
end

return counter