-- GPS virtual course for F3F script for EdgeTX and OpenTX
-- https://rc-soar.com/edgetx/lua/gpsf3f/
-- Copyright (c) Michael Shellim 2025 all rights reserved.

-- Manages logging of telemetry data to a file.

local logging = {}
local f             -- file handle for log file.

-- Creates a log file in /LOGS folder. The file name is based on the current date and time.
-- This function also enables logging (if not called, then logging.write() does nothing).
local function start()
    if f then return end  -- already open, do nothing
    local dt = getDateTime()
    local logfile = "/LOGS/" ..
                    dt.year ..
                    string.format ("%02d",dt.mon) ..
                    string.format ("%02d",dt.day) .. "_" ..
                    string.format ("%02d",dt.hour) ..
                    string.format ("%02d",dt.min) ..
                    string.format ("%02d",dt.sec) .. ".csv"
    f = io.open(logfile, "a")
end

-- Closes the log file.
local function stop()
    if f then
        io.close(f)
        f = nil
    end
end

-- Writes up to 5 parameters to log file, comma separated
-- If the log file is not open, then this function does nothing.
function logging.write (...)
    if not f then return end
    local v2, v3, v4, v5, v6 = ...
    local string = 
            (v2 or "") .. ','..
            (v3 or "") .. ','..
            (v4 or "") .. ','..
            (v5 or "") .. ','..
            (v6 or "") .. '\r\n'
    io.write(f, string)
end


-- Toggles logging 
function logging.toggle ()
    if f then
        stop()
    else
        start()
    end
end

function logging.isActive() 
    return f ~= nil and 'On' or 'Off'
end

return logging